// mainfrm.cpp
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1999 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and related
// electronic documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.
//
// Purpose: implementation of the CMainFrame class
//
// Functions:
//      Most of this file was generated by AppWizard.  The functions
//      which contain code specific to this sample are:
//
//      CMainFrame::GetMessageString()   -- override of CFrameWnd::GetMessageString
//                                          to customize message on status bar

#include "stdafx.h"
#include "dynamenu.h"

#include "mainfrm.h"
#include "dmdoc.h"    // for color definitions

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

#if (_WIN32_WCE > 200)
	if(!m_wndCommandBar.Create(this) ||
	   !m_wndCommandBar.InsertMenuBar(IDR_MAINFRAME) ||
	   !m_wndCommandBar.AddAdornments())
	{
		TRACE0("Failed to create CommandBar\n");
		return -1;      // fail to create
	}
#else // MFC for Windows CE 1.0 and 2.0
	if(!AddAdornments(0))
	{
		TRACE0("Failed to create CommandBar\n");
		return -1;      // fail to create
	}
#endif

	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

void CMainFrame::RefreshColorMenu()
{
	// Get the active document
	CDynaMenuDoc* pDoc = (CDynaMenuDoc*)GetActiveDocument();
	ASSERT_KINDOF(CDynaMenuDoc, pDoc);

	CMenu* pTopMenu = AfxGetMainWnd()->GetMenu();
	CMenu* pColorMenu = pTopMenu->GetSubMenu(1);
	
	// Delete existing color options
	for (int i = 0; i < NUM_TEXTCOLOR; i++)
		pColorMenu->DeleteMenu(pDoc->m_aColorDef[i].m_nID, MF_BYCOMMAND);

	// Delete the separator
	if (pColorMenu->GetMenuItemID(0) == 0)	// SEPERATOR
		pColorMenu->DeleteMenu(0, MF_BYPOSITION);

	int nColors = 0;
	// Insert chosen color options
	for (i = 0; i < NUM_TEXTCOLOR; i++)
	{
		if (pDoc->m_abAllowColor[i] == TRUE)
		{
			CString strColor;
			strColor.LoadString(pDoc->m_aColorDef[i].m_nString);
			pColorMenu->InsertMenu(ID_COLOR_OPTIONS, MF_STRING,
				pDoc->m_aColorDef[i].m_nID, strColor);
			nColors++;
		}
	}

	// Add separator if there are any color options
	if (nColors > 0)
		pColorMenu->InsertMenu(ID_COLOR_OPTIONS, MF_SEPARATOR,
			0, _T(""));
}
